M5_Vehicle = AG60_Vehicle or {};
M5_Vehicle.ContainerAccess = {}


function M5_Vehicle.ContainerAccess.M5_TruckBed(vehicle, part, chr)
    if chr:getVehicle() == vehicle then
        local seat = vehicle:getSeat(chr)
        -- Check if the seated player can access the trunk storage
        -- Only characters in specific seats can access it
        if seat == 0 or seat == 1 or seat == 2 or seat == 3 or seat == 4 or seat == 5 then
            return true
        end
    elseif chr:getVehicle() then
        -- Can't reach from inside a different vehicle.
        return false
    else
        -- Standing outside the vehicle.
        if not vehicle:isInArea(part:getArea(), chr) then return false end
        
        local rearLeftDoor = vehicle:getPartById("DoorRearLeft")
        local rearRightDoor = vehicle:getPartById("DoorRearRight")
        
        -- Check if at least one of the doors exists and is open
        if (rearLeftDoor and rearLeftDoor:getDoor() and rearLeftDoor:getDoor():isOpen()) or
           (rearRightDoor and rearRightDoor:getDoor() and rearRightDoor:getDoor():isOpen()) then
            return true
        end
    end
    
    return false
end



